#!/usr/bin/perl -w  -*-cperl-*-
# Written by Annett Sullivan, USGS annett@usgs.gov
# this program strips zeros from the Detroit output temp (two) file
# (for periods where outflow is zero, w2 lists temp as 0)
# also puts qwo file into Big Cliff folder


#destination for new two file
$dest = "Detroit_two_nozero_34.opt";
open OUT, ">$dest"
  or die "Can't open file for output: $!";

#Detroit two output file
$source = "Detroit_two_34.opt";
open IN, $source
  or die "Can't open file for input: $!";

$counter=0;
while ($inp_line = <IN>) {
  if ($inp_line =~ /\./) {
    ($jday, $temp) = split ' ', $inp_line;
    if ($temp>0.00 && $counter==0) {
      $temp_init = $temp;
      #printf "%8.2f%8.2f\n", $jday, $temp_init;
      $counter=1;	
    }
  }
}
close IN;

#Detroit two output file
$source = "Detroit_two_34.opt";
open IN, $source
  or die "Can't open file for input: $!";

while ($inp_line = <IN>) {
  if ($inp_line !~ /\./) {
    printf OUT $inp_line;
  }
  if ($inp_line =~ /\./) {
    ($jday, $temp) = split ' ', $inp_line;
    if ($temp>0.00) {
      printf OUT "%8.3f%8.2f\n", $jday, $temp;
    }
    if ($temp<0.0001 && $jday < 1.01) {
      printf OUT "%8.3f%8.2f\n", "1.000", $temp_init;
    }
  }
}

printf OUT "%8.3f%8.2f\n", "366.000", $temp_init;


close IN;

sub get_line {
# prompts for, reads, chomps, and returns a line of input
    print $_[0];
    chomp(my $line=<STDIN>);
    $line;
}