Attribute VB_Name = "modSpearmansRho"
'
' Purpose:
' To hold subroutines and functions necessary for calculating Spearman's Rho, confidence limit, and significance
' History:
' Version 1.0 Feb 2010 by Gregory E. Granato
'
Option Compare Database
Option Explicit         ' Must declare all variables
' Option Base 0           ' Arrays dimensioned from 0 to number-1 unless explicitly defined.


Public Sub PopulateRankTables(strSQL01 As String, strSQL02 As String, intOutErr As Integer)


Dim bHasdata As Boolean                 ' has data
Dim lngCount01 As Long
Dim lngCount02 As Long
Dim lngIndex() As Long
Dim dValue() As Double
Dim lngI As Long

Dim rst As ADODB.Recordset

On Error GoTo PopulateRankTables_Err:
intOutErr = 0
Call modHandleData.ClearTableEntries("tblRankTable01", intOutErr)
Call modHandleData.ClearTableEntries("tblRankTable02", intOutErr)

If intOutErr <> 0 Then Exit Sub

' **********************
' Do tblRankTable01
' **********************

' 1) Read input SQL
  Set rst = New ADODB.Recordset
  rst.Open strSQL01, CurrentProject.Connection, adOpenStatic
' Check values
 bHasdata = False
 If rst.BOF And rst.EOF Then  ' There is no data for this analysis
  bHasdata = False
 ElseIf IsNull(rst.Fields(0).Value) = False Then
  If IsEmpty(rst.Fields(0).Value) = False Then bHasdata = True ' There is data for this analysis
 End If
  If bHasdata = False Then
   DoCmd.Hourglass False
   ' Clean up recordset
   Call modHandleData.CloseRecordset(rst)
   Call modHandleData.NothingRecordset(rst)
   intOutErr = 10
   Exit Sub
  End If
  ' Get count
  rst.MoveFirst
  rst.MoveLast
  rst.MoveFirst
  lngCount01 = rst.RecordCount
  ' Redimension array
  ReDim lngIndex(1 To lngCount01) As Long
  ReDim dValue(1 To lngCount01) As Double
  
  ' Get values
  For lngI = 1 To lngCount01
   lngIndex(lngI) = rst.Fields(0).Value
   dValue(lngI) = rst.Fields(1).Value
   rst.MoveNext
  Next lngI
  ' Clean up recordset
   Call modHandleData.CloseRecordset(rst)
   Call modHandleData.NothingRecordset(rst)
  
  '2) Write Values
  Set rst = New ADODB.Recordset
  rst.Open "tblRankTable01", CurrentProject.Connection, adOpenKeyset, adLockOptimistic
  For lngI = 1 To lngCount01
   rst.AddNew
   rst.Fields(0).Value = lngIndex(lngI)
   rst.Fields(1).Value = dValue(lngI)
   rst.Update
   rst.MoveNext
  Next lngI
  ' Clean up recordset
  Call modHandleData.CloseRecordset(rst)
  Call modHandleData.NothingRecordset(rst)
   
' **********************
' Do tblRankTable02
' **********************

' 1) Read input SQL
  Set rst = New ADODB.Recordset
  rst.Open strSQL02, CurrentProject.Connection, adOpenStatic
' Check values
 bHasdata = False
 If rst.BOF And rst.EOF Then  ' There is no data for this analysis
  bHasdata = False
 ElseIf IsNull(rst.Fields(0).Value) = False Then
  If IsEmpty(rst.Fields(0).Value) = False Then bHasdata = True ' There is data for this analysis
 End If
  If bHasdata = False Then
   DoCmd.Hourglass False
  ' Clean up recordset
   Call modHandleData.CloseRecordset(rst)
   Call modHandleData.NothingRecordset(rst)
   intOutErr = 10
   Exit Sub
  End If
  ' Get count
  rst.MoveFirst
  rst.MoveLast
  rst.MoveFirst
  lngCount02 = rst.RecordCount
  ' Redimension array
  ReDim lngIndex(1 To lngCount02) As Long
  ReDim dValue(1 To lngCount02) As Double
  
  ' Get values
  For lngI = 1 To lngCount02
   lngIndex(lngI) = rst.Fields(0).Value
   dValue(lngI) = rst.Fields(1).Value
   rst.MoveNext
  Next lngI
' Clean up recordset
 Call modHandleData.CloseRecordset(rst)
 Call modHandleData.NothingRecordset(rst)
  
  '2) Write Values
  Set rst = New ADODB.Recordset
  rst.Open "tblRankTable02", CurrentProject.Connection, adOpenKeyset, adLockOptimistic
  For lngI = 1 To lngCount01
   rst.AddNew
   rst.Fields(0).Value = lngIndex(lngI)
   rst.Fields(1).Value = dValue(lngI)
   rst.Update
   rst.MoveNext
  Next lngI
' Clean up recordset
 Call modHandleData.CloseRecordset(rst)
 Call modHandleData.NothingRecordset(rst)
             
  If lngCount02 <> lngCount01 Then intOutErr = 99

Exit Sub
PopulateRankTables_Err:
' Clean up recordset
 Call modHandleData.CloseRecordset(rst)
 Call modHandleData.NothingRecordset(rst)
intOutErr = -99
Exit Sub
End Sub



Public Sub GetRhoStats(dRho As Double, dUpperOut As Double, dLowerOut As Double, dPZero As Double, _
                       lngCount As Long, lngErr As Long)
' Purpose: To develop rank correlation function
' History: Version 1.0 Feb. 2010 by Gregory E. Granato
'
Dim bHasdata As Boolean
Dim rst As ADODB.Recordset

Dim strSQL01 As String
Dim strSQL02 As String

Dim lngI As Long

'Dim strSQL01 As String
Dim dArray01() As Double
Dim dRanks01() As Double
Dim dS01 As Double
Dim dTie01 As Double
Dim lngCount01 As Long

'Dim lngID() As Long

'Dim strSQL02 As String
Dim dArray02() As Double
Dim dRanks02() As Double
Dim dS02 As Double
Dim dTie02 As Double
Dim lngCount02 As Long

'Dim dRho As Double

' Confidence intervals
'Dim dUpperOut As Double
'Dim dLowerOut As Double
Dim intError As Integer
'Dim dPZero As Double

' ***************
' Get First Recordset

On Error GoTo x_Err:
lngErr = 0

' ********************
' Get Array 1 values in ascending order
' ********************

Set rst = New ADODB.Recordset

strSQL01 = "SELECT tblRankTable01.lng01Index, tblRankTable01.d01Value, tblRankTable01.d01Rank " & _
           "FROM tblRankTable01 " & _
           "WHERE (((tblRankTable01.d01Value) Is Not Null)) " & _
           "ORDER BY tblRankTable01.d01Value;"

'rst.Open strSQL01, CurrentProject.Connection, adOpenStatic
rst.Open strSQL01, CurrentProject.Connection, adOpenKeyset, adLockOptimistic

' Check values
 bHasdata = False
 If rst.BOF And rst.EOF Then  ' There is no data for this analysis
  bHasdata = False
 ElseIf IsNull(rst.Fields(0).Value) = False Then
  If IsEmpty(rst.Fields(0).Value) = False Then bHasdata = True ' There is data for this analysis
 End If
  If bHasdata = False Then
   DoCmd.Hourglass False
   ' Clean up recordset
   Call modHandleData.CloseRecordset(rst)
   Call modHandleData.NothingRecordset(rst)
   lngErr = 2
   Exit Sub
  End If
  ' Get count
  rst.MoveFirst
  rst.MoveLast
  rst.MoveFirst
  lngCount01 = rst.RecordCount
  lngCount = lngCount01
  ' Redimension array
  ReDim dArray01(1 To lngCount01) As Double
  ReDim dRanks01(1 To lngCount01) As Double
  'ReDim lngID(1 To lngCount01) As Long
  ' Get values
  For lngI = 1 To lngCount01
   'lngID(lngI) = rst.Fields(0).Value
   dArray01(lngI) = rst.Fields(1).Value
   rst.MoveNext
  Next lngI
  
  ' Get Ranks
  Call GetRanks(dArray01, dRanks01, dTie01, dS01, lngCount01)
   
  ' ********************
  ' write Ranks
  ' ********************
  'Close recordset
   'Call RecordSetClose(rst)
   'Set rst = New ADODB.Recordset
   
   'rst.Open strSQL01, CurrentProject.Connection, adOpenDynamic
    
    rst.MoveFirst
     For lngI = 1 To lngCount01
      rst.Fields(2).Value = dRanks01(lngI)
      rst.Update
      rst.MoveNext
     Next lngI
  
 ' Clean up recordset
  Call modHandleData.CloseRecordset(rst)
  Call modHandleData.NothingRecordset(rst)
  
  ' ********************
  ' Get Array 1 ranks in index order
  ' ********************
  Set rst = New ADODB.Recordset

  strSQL01 = "SELECT tblRankTable01.lng01Index, tblRankTable01.d01Rank " & _
             "FROM tblRankTable01 " & _
             "WHERE (((tblRankTable01.d01Rank) Is Not Null)) " & _
             "ORDER BY tblRankTable01.lng01Index;"
             
  rst.Open strSQL01, CurrentProject.Connection, adOpenStatic
             
  ReDim dRanks01(1 To lngCount01) As Double
  ReDim lngID(1 To lngCount01) As Long
' Check values
  bHasdata = False
 If rst.BOF And rst.EOF Then  ' There is no data for this analysis
  bHasdata = False
 ElseIf IsNull(rst.Fields(0).Value) = False Then
  If IsEmpty(rst.Fields(0).Value) = False Then bHasdata = True ' There is data for this analysis
 End If
  If bHasdata = False Then
   DoCmd.Hourglass False
   ' Clean up recordset
   Call modHandleData.CloseRecordset(rst)
   Call modHandleData.NothingRecordset(rst)
   lngErr = 2
   Exit Sub
  End If
  rst.MoveFirst
  ' Get values
  For lngI = 1 To lngCount01
   'lngID(lngI) = rst.Fields(0).Value
   dRanks01(lngI) = rst.Fields(1).Value
   rst.MoveNext
  Next lngI
  'Close recordset
  ' Clean up recordset
  Call modHandleData.CloseRecordset(rst)
  Call modHandleData.NothingRecordset(rst)

' ********************************************************************************************************

' ********************
' Get Array 2 values in ascending order
' ********************
  Set rst = New ADODB.Recordset
  
strSQL02 = "SELECT tblRankTable02.lng02Index, tblRankTable02.d02Value, tblRankTable02.d02Rank " & _
           "FROM tblRankTable02 " & _
           "WHERE (((tblRankTable02.d02Value) Is Not Null)) " & _
           "ORDER BY tblRankTable02.d02Value;"
           
rst.Open strSQL02, CurrentProject.Connection, adOpenKeyset, adLockOptimistic

' Check values
 bHasdata = False
 If rst.BOF And rst.EOF Then  ' There is no data for this analysis
  bHasdata = False
 ElseIf IsNull(rst.Fields(0).Value) = False Then
  If IsEmpty(rst.Fields(0).Value) = False Then bHasdata = True ' There is data for this analysis
 End If
  If bHasdata = False Then
   DoCmd.Hourglass False
  ' Clean up recordset
   Call modHandleData.CloseRecordset(rst)
   Call modHandleData.NothingRecordset(rst)
   Exit Sub
  End If
  ' Get count
  rst.MoveFirst
  rst.MoveLast
  rst.MoveFirst
  lngCount02 = rst.RecordCount
  
  If lngCount02 <> lngCount01 Then
   'MsgBox "Error: Array 1 has " & lngCount01 & " records and Array 1 has " & lngCount02 & " Records", vbCritical, "Error: "
   'DoCmd.Hourglass False
   lngErr = 1
   ' Clean up recordset
   Call modHandleData.CloseRecordset(rst)
   Call modHandleData.NothingRecordset(rst)
   Exit Sub
  End If
  
  ' Redimension array
  ReDim dArray02(1 To lngCount01) As Double
  ReDim dRanks02(1 To lngCount01) As Double
  ' Get values
  lngI = 0
  ' Get values
  For lngI = 1 To lngCount01
   dArray02(lngI) = rst.Fields(1).Value
   rst.MoveNext
  Next lngI
  
  ' Get Ranks
  Call GetRanks(dArray02, dRanks02, dTie02, dS02, lngCount01)
    
  ' ********************
  ' write Ranks
  ' ********************
    rst.MoveFirst
     For lngI = 1 To lngCount01
      rst.Fields(2).Value = dRanks02(lngI)
      rst.Update
      rst.MoveNext
     Next lngI

   
   ' Clean up recordset
   Call modHandleData.CloseRecordset(rst)
   Call modHandleData.NothingRecordset(rst)
   
  ' ********************
  ' Get Array 2 values in index order
  ' ********************
  Set rst = New ADODB.Recordset

  strSQL02 = "SELECT tblRankTable02.lng02Index, tblRankTable02.d02Rank " & _
             "FROM tblRankTable02 " & _
             "WHERE (((tblRankTable02.d02Rank) Is Not Null)) " & _
             "ORDER BY tblRankTable02.lng02Index;"
             
  rst.Open strSQL02, CurrentProject.Connection, adOpenStatic
             
  ReDim dRanks02(1 To lngCount01) As Double
  ReDim lngID(1 To lngCount01) As Long
' Check values
  bHasdata = False
 If rst.BOF And rst.EOF Then  ' There is no data for this analysis
  bHasdata = False
 ElseIf IsNull(rst.Fields(0).Value) = False Then
  If IsEmpty(rst.Fields(0).Value) = False Then bHasdata = True ' There is data for this analysis
 End If
  If bHasdata = False Then
   DoCmd.Hourglass False
   ' Clean up recordset
   Call modHandleData.CloseRecordset(rst)
   Call modHandleData.NothingRecordset(rst)
   lngErr = 3
   Exit Sub
  End If
  rst.MoveFirst
  ' Get values
  For lngI = 1 To lngCount01
   'lngID(lngI) = rst.Fields(0).Value
   dRanks02(lngI) = rst.Fields(1).Value
   rst.MoveNext
  Next lngI
   ' Clean up recordset
   Call modHandleData.CloseRecordset(rst)
   Call modHandleData.NothingRecordset(rst)
   
   
  ' Get Rho
  dRho = fnCalculateRho(dRanks01, dRanks02, lngCount01, dS01, dS02)
  
  ' Get CI
  Call GetFishersZ(dRho, lngCount01, 95#, dUpperOut, dLowerOut, intError, dPZero)

 Exit Sub
x_Err:
lngErr = -99

MsgBox Str(Err.Number) & ": " & Err.Description
   ' Clean up recordset
   Call modHandleData.CloseRecordset(rst)
   Call modHandleData.NothingRecordset(rst)

 Exit Sub
End Sub


Public Sub GetRanks(dMyInput() As Double, dMyOutput() As Double, dMyTies As Double, dS As Double, lngMyCount As Long)
' Purpose: Given the sorted array dMyInput of size lngMyCount return the associated ranks dMyOutput
' History: Version 1.0 Feb. 2010 by Gregory E. Granato
'
' Reference: Adapted, modified and translated to VBA from
' subroutine crank(n,w,s) Section 14.6
' Press, W.H., Flannery, B.P., Teukolsky S.A., and Vetterling, W.T.
' 1992, Numerical Recipes in Fortran 77--The Art of Scientific
' Computing (2nd ed.): New York: Cambridge University Press, 992 p.
'
'
Dim lngJJ As Long
Dim lngJ As Long
Dim lngK As Long
Dim lngKMax As Long
Dim lngCount As Long
Dim dTempRank As Double
Dim dTempValue As Double
Dim dT As Double

' Start with first rank sorting in the calling routine defines the count
lngJ = 1
dMyTies = 0#
dS = 0#
dT = 0#

If lngJ = lngMyCount Then
 dMyOutput(1) = CDbl(lngJ)
 Exit Sub
End If
lngK = 2
For lngJ = 1 To lngMyCount
 If lngK <= lngMyCount Then
  If dMyInput(lngJ) <> dMyInput(lngK) Then ' Not a tie
   ' Assign rank
   dMyOutput(lngJ) = CDbl(lngJ)
   lngK = lngK + 1
  Else
   lngCount = 1
   Do
    lngCount = lngCount + 1
    If lngK < lngMyCount Then
     lngK = lngK + 1
     dTempValue = dMyInput(lngK)
    ElseIf lngK = lngMyCount Then
     dTempValue = dMyInput(lngMyCount)
     lngK = lngMyCount + 1
    Else
     lngK = lngMyCount + 1
     If dMyInput(lngMyCount) <> -1.7976931348623E+308 Then
      dTempValue = -1.7976931348623E+308
     Else
      dTempValue = -1.7976931348623E+308 + 1#
     End If
    End If
   Loop While dMyInput(lngJ) = dTempValue
   ' calculate average rank
   dTempRank = (lngJ + lngK - 1) / 2
   dT = lngK - lngJ
   dMyTies = dMyTies + dT
   dS = dS + (dT ^ 3 - dT)
   ' Assign average rank
   For lngJJ = lngJ To lngK - 1
    dMyOutput(lngJJ) = dTempRank
   Next lngJJ
   ' Clean up
   lngJ = lngK - 1
   lngK = lngK + 1
  End If
 ElseIf dMyOutput(lngMyCount) = 0 Then
  dMyOutput(lngMyCount) = lngMyCount
 End If
Next lngJ

Exit Sub


End Sub

Private Function fnCalculateRho(dMyRanks1() As Double, dMyRanks2() As Double, lngMyCount As Long, _
                                dMyS01 As Double, dMyS02 As Double) As Double
'
' Purpose: To calculate Spearman's rho
'
' History: Version 1.0 Feb. 2010 by Gregory E. Granato
'
' Reference: Adapted, modified and translated to VBA from
' subroutine spear Section 14.6
' Press, W.H., Flannery, B.P., Teukolsky S.A., and Vetterling, W.T.
' 1992, Numerical Recipes in Fortran 77--The Art of Scientific
' Computing (2nd ed.): New York: Cambridge University Press, 992 p.
'
Dim dD As Double
Dim dDenom As Double
Dim lngJ As Long

' Sum the squared difference of ranks.
dD = 0#
For lngJ = 1 To lngMyCount
 dD = dD + (dMyRanks1(lngJ) - dMyRanks2(lngJ)) ^ 2#
Next lngJ
' Get denominator
dDenom = (lngMyCount ^ 3#) - lngMyCount

fnCalculateRho = 1# - (6# / dDenom) * (dD + (dMyS01 / 12#) + (dMyS02 / 12#))
fnCalculateRho = fnCalculateRho / (((1# - (dMyS01 / dDenom)) ^ (1# / 2#)) * ((1# - (dMyS01 / dDenom)) ^ (1# / 2#)))

Exit Function

End Function

Private Sub GetFishersZ(dRhoIn As Double, lngNIn As Long, dInPctCI As Double, _
                       dUpperOut As Double, dLowerOut As Double, interr As Integer, _
                       Optional dPZero As Double)
'
' Purpose: To calculate the confidence intervals of Spearman's Rho or Pearson's R
' If zero is within the upper and lower confidence interval dLowerOut to dUpperOut
' then dRhoIn not statistically significant at the dZInPercent confidence level.
' Otherwise dRhoIn is Statistically significant
'
' History: Created February 2010 by Gregory E. Granato
'
' Arguments
' dRhoIn    Input Rho or R value
' lngNIn    Input Number of values in the data set
' dInPctCI  Input desired confidence interval value (0-100) ie 95% confidence interval
' dLowerOut Output lower bound of confidence interval given dZinPercent
' dUpperOut Output lower bound of confidence interval given dZinPercent
Dim strMsgStr As String
Dim dMyRho As Double
Dim dNormalCIvalue As Double
Dim dNormalKvalue As Double
Dim dFishersZ As Double
Dim dZStandardError As Double
Dim dFnZ As Double
Dim dZZed As Double
Dim dPZed As Double

On Error GoTo GetFishersZ_Err:
interr = 0
' Check Rho
If Abs(dRhoIn) > 1 Then
 strMsgStr = "Fisher's Z error." & vbCrLf & "Rho must be in the interval -1 to 1"
 MsgBox strMsgStr, vbCritical, "Input Error Sub GetFishersZ"
 dUpperOut = 0#
 dLowerOut = 0#
 interr = 1
 Exit Sub
End If
' Check Rho
If lngNIn < 3# Then
 strMsgStr = "Fisher's Z error." & vbCrLf & "The number of samples must be greater than 3."
 MsgBox strMsgStr, vbCritical, "Input Error Sub GetFishersZ"
 dUpperOut = 0#
 dLowerOut = 0#
 interr = 2
 Exit Sub
End If
' Check dZInP01
If dInPctCI < 0# Or dInPctCI > 100# Then
 strMsgStr = "Fisher's Z error." & vbCrLf & "The number of samples must be greater than 3."
 MsgBox "Fisher's Z error. The confidence interval p value must be in the range 0-1", vbCritical, "Input Error Sub GetFishersZ"
 dUpperOut = 0#
 dLowerOut = 0#
 interr = 2
 Exit Sub
End If

dMyRho = dRhoIn

If Abs(dMyRho) = 1 Then dMyRho = (Abs(dMyRho) - 0.00000001) * (dMyRho / Abs(dMyRho))
 
 
 ' calculate input value 95% confidence interval is from -.975 to 0.975
 ' so
 dNormalCIvalue = 1# - ((1# - (dInPctCI / 100#)) / 2#)

 ' Set up values
 dNormalKvalue = fndAS241PToNormalK(dNormalCIvalue)
 dFishersZ = 0.5 * (Log(1 + dMyRho) - Log(1 - dMyRho))
 dZStandardError = Sqr(1# / ((1# * lngNIn) - 3#))
 ' calculate upper
 dFnZ = Exp((2# * (dFishersZ + dNormalKvalue * dZStandardError)))
 dUpperOut = (dFnZ - 1#) / (dFnZ + 1#)
 If dRhoIn = 1# Then dUpperOut = 1#
 
 ' calculate lower
 dFnZ = Exp((2# * (dFishersZ - dNormalKvalue * dZStandardError)))
 dLowerOut = (dFnZ - 1#) / (dFnZ + 1#)
 If dRhoIn = -1# Then dLowerOut = -1#
 
 ' *********** check *************
 ' Optional calculate P at which Rho = 0 ****************
   dZZed = Abs((dFishersZ - 0#) / Sqr(1# / ((1# * lngNIn) - 3#)))
   dPZed = dZtoP(dZZed)
   dPZed = (1 - dPZed) * 2#
   dPZero = dPZed
 Exit Sub
GetFishersZ_Err:
 MsgBox "Error", vbCritical, "Error"
 Exit Sub
End Sub

Private Function fndAS241PToNormalK(dMyUniform As Double) As Double
'
' Purpose:
' To convert a uniform random number (0<U<1) to the equivalent standard normal score value with Algorithm AS241
'
' History:
' Version 1.0 June 2006 by G.E. Granato ggranato@usgs.gov
' Method developed from algorithm developed and described as Accurate to more than 10^-7 and less than 6x10-16
' Wichura, M.J., 1988, Algorithm AS241--The percentage points of the normal distribution:
' Applied Statistics, Journal of the Royal Statistical Society (Series C)
' v. 37, no. 3, p. 477-484.
'
' dMyUniform input uniform random numbers in interval 1E-19 < dMyUniform <1
' dMyNormal output standard normal score values
' dA0-dA7, dC0-dC7, dC0-dC7 polynomial coefficients for numerator
' dB1-dB7, dD1-dD7, dF1-dF7 polynomial coefficients for denominator
'
' Assign P values
' Arguments
Dim dMyP As Double
Dim dY As Double
Dim dR As Double
Dim dQ As Double
Dim dMyNormal As Double

' Get the equation coefficients
Dim dA0 As Double, dA1 As Double, dA2 As Double, dA3 As Double, dA4 As Double, dA5 As Double, dA6 As Double, dA7 As Double
Dim dB1 As Double, dB2 As Double, dB3 As Double, dB4 As Double, dB5 As Double, dB6 As Double, dB7 As Double
Dim dC0 As Double, dC1 As Double, dC2 As Double, dC3 As Double, dC4 As Double, dC5 As Double, dC6 As Double, dC7 As Double
Dim dD1 As Double, dD2 As Double, dD3 As Double, dD4 As Double, dD5 As Double, dD6 As Double, dD7 As Double
Dim dE0 As Double, dE1 As Double, dE2 As Double, dE3 As Double, dE4 As Double, dE5 As Double, dE6 As Double, dE7 As Double
Dim dF1 As Double, dF2 As Double, dF3 As Double, dF4 As Double, dF5 As Double, dF6 As Double, dF7 As Double


On Error GoTo fndAS241PToNormalK_Err:

' Assign values

dA0 = 3.38713287279637
dA1 = 133.141667891784
dA2 = 1971.59095030655
dA3 = 13731.6937655095
dA4 = 45921.9539315499
dA5 = 67265.7709270087
dA6 = 33430.575583588
dA7 = 2509.08092873012
dB1 = 42.3133307016009
dB2 = 687.187007492058
dB3 = 5394.19602142475
dB4 = 21213.7943015866
dB5 = 39307.8958000927
dB6 = 28729.0857357219
dB7 = 5226.49527885285
dC0 = 1.42343711074968
dC1 = 4.63033784615654
dC2 = 5.76949722146069
dC3 = 3.6478483247632
dC4 = 1.27045825245237
dC5 = 0.241780725177451
dC6 = 2.27238449892692E-02
dC7 = 7.74545014278341E-04
dD1 = 2.05319162663776
dD2 = 1.6763848301838
dD3 = 0.6897673349851
dD4 = 0.14810397642748
dD5 = 1.51986665636165E-02
dD6 = 5.47593808499534E-04
dD7 = 1.05075007164442E-09
dE0 = 6.6579046435011
dE1 = 5.46378491116411
dE2 = 1.78482653991729
dE3 = 0.296560571828504
dE4 = 2.65321895265761E-02
dE5 = 1.24266094738807E-03
dE6 = 2.71155556874348E-05
dE7 = 2.01033439929228E-07
dF1 = 0.599832206555887
dF2 = 0.136929880922735
dF3 = 1.48753612908506E-02
dF4 = 7.86869131145613E-04
dF5 = 1.84631831751005E-05
dF6 = 1.42151175831644E-07
dF7 = 2.04426310338993E-15

' Short cut if near zero
If (dMyUniform > 0.499999999999999) And (dMyUniform < 0.500000000000001) Then  ' if U = 0.5 then Z=0
 fndAS241PToNormalK = 0#
 Exit Function
End If

' Condition Input
If dMyUniform <= 1E-21 Then dMyUniform = 1E-21           ' Keep within bounds
If dMyUniform >= 1# Then dMyUniform = 0.999999999999999  ' Keep within bounds

dMyP = dMyUniform

dQ = dMyP - 0.5

If Abs(dQ) <= 0.425 Then ' Is the value close to one-half use first polygon

 dR = 0.180625 - (dQ * dQ)
 dMyNormal = dQ * (((((((dA7 * dR + dA6) * dR + dA5) * dR + dA4) * dR + dA3) * dR + dA2) * dR + dA1) * dR + dA0) / _
                (((((((dB7 * dR + dB6) * dR + dB5) * dR + dB4) * dR + dB3) * dR + dB2) * dR + dB1) * dR + 1#)


Else  ' use other polygons
 If dQ < 0# Then
  dR = dMyP
 Else
  dR = 1# - dMyP
 End If
 
 dR = Sqr(-1# * Log(dR))
 
 If dR <= 5# Then
  dR = dR - 1.6
  dMyNormal = (((((((dC7 * dR + dC6) * dR + dC5) * dR + dC4) * dR + dC3) * dR + dC2) * dR + dC1) * dR + dC0) / _
                (((((((dD7 * dR + dD6) * dR + dD5) * dR + dD4) * dR + dD3) * dR + dD2) * dR + dD1) * dR + 1#)
 Else
  dR = dR - 5#
  dMyNormal = (((((((dE7 * dR + dE6) * dR + dE5) * dR + dE4) * dR + dE3) * dR + dE2) * dR + dE1) * dR + dE0) / _
                (((((((dF7 * dR + dF6) * dR + dF5) * dR + dF4) * dR + dF3) * dR + dF2) * dR + dF1) * dR + 1#)
 End If
 
 If (dQ < 0) Then dMyNormal = dMyNormal * -1#
 
End If

fndAS241PToNormalK = dMyNormal  ' Assign final value

Exit Function
' Error
fndAS241PToNormalK_Err:
 fndAS241PToNormalK = 0#
 Exit Function
End Function



Private Function dZtoP(dInZ As Double) As Double
' Purpose: to get the Probability P from the normal Z score
'
' History Feb 2010 by ggranato@usgs.gov
'
' Source:
' Abramowitz, Milton; Stegun, Irene A., eds., 1965,
' Handbook of Mathematical Functions with Formulas, Graphs, and Mathematical Tables:
' United States Department of Commerce, National Bureau of Standards,
' Applied Mathematics Series 55, 1046 p.'
' Equation: 26.2.19 accurate to +/- 0.15x10^-7
'
' Argument:
' dInZ normal Z variate can be calculated as Z = (Xi-Average)/Standard deviation
'
Dim dB As Double
Dim dZ As Double

On Error GoTo dZtoP_Err:

dZ = Abs(dInZ)

dB = 0.5 * ((1# + 0.049867347 * dZ + 0.0211410061 * (dZ ^ 2#) + 0.0032776263 * (dZ ^ 3#) _
     + 0.0000380036 * (dZ ^ 4#) + 0.0000488906 * (dZ ^ 5#) + 0.000005383 * (dZ ^ 6#)) ^ (-16#))

If dInZ <= 0 Then
 dZtoP = dB
Else
 dZtoP = 1# - dB
End If

Exit Function
dZtoP_Err:
dZtoP = -1
Exit Function
End Function



